% Beispiel: Impuls- und Sprungantwort im z-Bereich (Signal Processing Toolbox)
% B.Hartmann, 21.11.2007

clear all
close all
clc
K = 5;
T = 5;
T0 = 1;                     % Abtastzeit [s]
                              %                          z
Gi = tf([1 0],[1 -0.82],T0) % bertragungsfunktion:  -------
                              %                        z - 0.82 
                              
                              %                          0.9
Gs = tf([0 0.9],[1 -0.82],T0) % bertragungsfunktion:  -------
                              %                        z - 0.82 
                              
G = tf([0 1],[1 0.2])
                              
[hi,ki] = step(Gi);           % Sprungantwort des Systems

[hs,ks] = step(Gs);           % Sprungantwort des Systems

[h,t] = step(G,ks(end));              % Sprungantwort des Systems

%%%%%%%%%%%%%%%
% Darstellung %
%%%%%%%%%%%%%%%

schrift = 16;

figure(1)
hold on
plot(ki,hi,'ro')
plot(ks,hs,'ko')
plot(t,h)
title('Sprungantwort','fontsize',schrift)
xlabel('t [s]','fontsize',schrift)
ylabel('h(t), hi(k*T0), hs(k*T0)','fontsize',schrift,'rotation',90)
legend('Gi','Gs','G','location','SouthEast')
set(gca,'fontsize',schrift,'linewidth',1.5)
line([0 35],[5 5],'Color','k','LineStyle','--')
line([0 35],[5.56 5.56],'Color','k','LineStyle','--')
hold off